unit SensorGroup02;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  Sensor01;

type
  TSensorGroup02Form = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SensorGroup02Form: TSensorGroup02Form;

// ================================================================
//     
// ================================================================
//      
const Max02SensorIndex = 3;
//  
var   SensorsArr02 : array [0..Max02SensorIndex] of TSensor;

// ================================================================
// ================================================================

implementation
{$R *.dfm}

// ================================================================
// ================================================================

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
//        
type TSensorsDesc = record
  XB    : integer;     // Left -     
  YB    : integer;     // Top  -     
  Title : string;      //   
  Min   : integer;     //    
  Max   : integer;     //    
end;
// ----------------------------------------------------------------
//   
const SensorsDesc : array [0..Max02SensorIndex] of TSensorsDesc =
( //  
  ( XB : 10;  YB : 40;       Title : ' 1'; Min : 10;  Max : 110 ),
  ( XB : 10;  YB : 40 + 165; Title : ' 2'; Min : 20;  Max : 120),
  //  
  ( XB : 260; YB : 40;       Title : ' 3'; Min : -10;  Max : 90),
  ( XB : 260; YB : 40 + 165; Title : ' 4'; Min : -20;  Max : 80)
);

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//     
procedure TSensorGroup02Form.FormCreate(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(SensorsArr02) to High(SensorsArr02)
   do begin
      if not Assigned(SensorsArr02[Ind])
      then begin
         SensorsArr02[Ind] := TSensor.Create(Panel1,
                              SensorsDesc[Ind].XB,
                              SensorsDesc[Ind].YB);
         with SensorsArr02[Ind]
         do begin
           Indx  := Ind;
           Title := SensorsDesc[Ind].Title;
           Min   := SensorsDesc[Ind].Min;
           Max   := SensorsDesc[Ind].Max;
         end;
      end;
   end;
   // Edit1.Text := IntToStr(AllocMemSize);
end;
// ----------------------------------------------------------------
//     
procedure TSensorGroup02Form.FormDestroy(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(SensorsArr02) to High(SensorsArr02)
   do begin
      if Assigned(SensorsArr02[Ind])
      then begin
       SensorsArr02[Ind].Free;
       SensorsArr02[Ind] := nil;
      end;
   end;
end;
// ================================================================
//   
// ================================================================
end.
